SET QUOTED_IDENTIFIER OFF
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT	@FACILITY_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		CREATE TABLE #ACT(ACT_ID INT, FLOW_ID UNIQUEIDENTIFIER)
		INSERT INTO #ACT(ACT.ACT_ID, ACT.FLOW_ID)
		SELECT A.ID, A.FLOW_ID
		FROM BMS.dbo.ACT AS A
		INNER JOIN BMS.dbo.TRANSFER_REQ AS TR ON A.ID = TR.ACT_ID			
		LEFT OUTER JOIN BMS.dbo.ACT AS A_EVN ON A_EVN.PARENT_ACT_ID = A.ID
		WHERE TR.FACILITY_UID = @FACILITY_UID AND A_EVN.ID IS NULL

		--DELETE FROM BMS DATABASE
		DELETE TR FROM BMS.dbo.TRANSFER_REQ AS TR
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID = TR.ACT_ID
				
		DELETE ACT FROM BMS.dbo.ACT AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID = ACT.ID

		--DELETE FROM BMS_HISTORY DATABASE
		DELETE TR FROM BMS_HISTORY.dbo.TRANSFER_REQ_H AS TR 
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID = TR.ACT_ID

		DELETE ACT FROM BMS_HISTORY.dbo.ACT_H AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID = ACT.ID	

		--DELETE FROM BMS_InstanceStore
		CREATE TABLE #SURROGATE_INSTANCE(SurrogateInstanceId INT)
		INSERT INTO #SURROGATE_INSTANCE(SurrogateInstanceId)
		SELECT SurrogateInstanceId FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS SI
		INNER JOIN #ACT AS ACT ON ACT.FLOW_ID = SI.Id  
		WHERE SI.BlockingBookmarks LIKE '%BMS.Workflows.WF.ITransferFlow%'

		DROP TABLE #ACT

		DELETE IPPT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancePromotedPropertiesTable] AS IPPT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IPPT.SurrogateInstanceId

		DELETE KT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[KeysTable] AS KT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = KT.SurrogateInstanceId

		DELETE IMCT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] AS IMCT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IMCT.SurrogateInstanceId

		DELETE RIT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[RunnableInstancesTable] AS RIT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = RIT.SurrogateInstanceId

		DELETE IT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS IT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IT.SurrogateInstanceId

		DROP TABLE #SURROGATE_INSTANCE
	SELECT 'Active VISN Waiting List - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
SET QUOTED_IDENTIFIER ON